﻿using System.ComponentModel.DataAnnotations;
using System.Linq;
using PpmsDataWebService.Models;

namespace PpmsDataWebService.Models
{
    public class ProviderService
    {
        [Key]
        public string Name { get; set; }

        public string AffiliationName { get; set; }

        public string RelationshipName { get; set; }

        public string ProviderName { get; set; }

        public string ProviderAgreementName { get; set; }

        public string SpecialtyName { get; set; }

        public HPP? HPP { get; set; }

        public string HighPerformingProvider { get; set; }

        public string CareSiteName { get; set; }

        public string CareSiteLocationAddress { get; set; }

        public string CareSiteAddressStreet { get; set; }

        public string CareSiteAddressCity { get; set; }

        public string CareSiteAddressState { get; set; }

        public string CareSiteAddressZipCode { get; set; }

        public decimal Latitude { get; set; }

        public decimal Longitude { get; set; }

        public string CareSitePhoneNumber { get; set; }

        public string OrganiztionGroupName { get; set; }

        public string DescriptionOfService { get; set; }

        public string Limitation { get; set; }
       

        //Single
        public virtual IQueryable<Provider> Provider { get; set; }

        //Single
        public virtual IQueryable<Specialty> Specialty { get; set; }

        //Many
        //Service Availabilities
        public virtual IQueryable<ServiceAvailability> ServiceAvailabilities { get; set; }

        //Agreement Providers
        public virtual IQueryable<AgreementProvider> AgreementProviders { get; set; }

    }
}